from __future__ import generators
import plus
import Arenas
import Hazards
import random

import math

class RingArena(Arenas.SuperArena):
    "The Robogames arena. Will you survive?"
    name = "Robogames"
    preview = "robogames/robogames_preview.bmp"
    game_types = ['DEATHMATCH', 'BATTLE ROYAL', 'TEAM MATCH']

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/robogames/robogames.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)
        fmod = 0.015
        degrad = 0.01745
        self.AddStaticCamera("Static 1", (0, 55.8, 2), (90*degrad, 90*degrad), degrad*37)

        self.AddWatchCamera("Watch Cam 1", (19, 10, -15), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Watch Cam 2", (-14, 10, 19), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Watch Cam 3", (15, 9, 19), (20, 30, 60*degrad, 20*degrad))
        self.AddWatchCamera("Watch Cam 4", (-9.3, 8, -15.04), (16, 22, 30*degrad, 20*degrad))

        self.AddSound = plus.createSound("Sounds/rwarenaloop4.wav", False, (0, 0, 0))
        plus.loopSound(self.AddSound)
                
        self.players = ()
		
    def __del__(self):
        if self.AddSound:
            plus.stopSound(self.AddSound)
            plus.removeSound(self.AddSound)
        Arenas.SuperArena.__del__(self)

    def AddShadowReceivers(self):
        pass
        
    def HazardsOn(self, on):
        self.AddCollisionLine((7, 15.25), (19, 3.25))
        self.AddCollisionLine((19, 3.25), (7, -8.75))
        self.AddCollisionLine((7, -8.75), (-5, 3.25))
        self.AddCollisionLine((-5, 3.25), (7, 15.25))
        return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):    
        if on: self.players = plus.getPlayers()
        return Arenas.SuperArena.Activate(self, on)
        
    def Introduction(self):
        sounds = self.intro_sounds
        
        # set initial camera & fade from black
        plus.setCameraPosition(-45,35,-45)
        plus.setCameraRotation(0.4012, 0.78539)
        plus.setCameraFOV(0.7753)
        plus.fadeFromBlack(.25)

        #start playing music loop
        self.intro_music = plus.createSound("Sounds/announcers/rwsilence.wav", False, (0,0,0))
        plus.setVolume(self.intro_music, 0, 0)
        plus.loopSound(self.intro_music)
        yield .25
        
        #load all sounds now to decrease lag later
        sounds['crowd'] = plus.createSound("Sounds/crowd/LoudCheer_Loop.wav", False, (0,0,0))
        
        arenaOpt = ("Sounds/announcers/rwringintro1.wav", "Sounds/announcers/rwringintro2.wav")
        sounds['arena'] = plus.createSound(random.choice(arenaOpt), False, (0,0,0))
        genericOpt = ("rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "rwsilence.wav", "Irwsilence.wav", "rwsilence.wav")
        sounds['generic'] = plus.createSound("Sounds/announcers/"+random.choice(genericOpt), False, (0,0,0))
        botOpt = ("Bots_YouCanFeelTension.wav", "Bots_ColdChill.wav", "Bots_FansLoveTheseBots.wav", "Bots_SeeingInterestingDesigns.wav", "Bots_CrowdPoisedBotsArmed.wav")
        sounds['bots'] = plus.createSound("Sounds/announcers/"+random.choice(botOpt), False, (0,0,0))
        
        #intro cam, welcom comment
        plus.playSound(sounds['arena'])
        plus.fadeInToLoop(sounds['crowd'], -100, 800)
        plus.animateCamera((-45,35,-45), (0.4012, 0.78539), 0.7753, (45,35,-45), (0.4012, -0.78539), 0.7753, 0, 8)
        yield 2
        plus.fadeOutLoop(sounds['crowd'], 8000)
        yield 1
        
        #play a generic (or specific) secondary comment
        plus.playSound(sounds['generic'])
        yield 5

        pcount = len(self.players)
        if pcount>0: plus.playSound(sounds['bots'])
        delaytime = 6 - pcount
        
        if 0 in self.players:
            #bot 1 cam
            plus.animateCamera((10,20,0), (0.533,-1.57), 0.6, (10,20,0), (0.533,-1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 1 in self.players:
            #bot 2 cam
            plus.animateCamera((-10,20,0), (0.533,1.57), 0.6, (-10,20,0), (0.533,1.57), 0.45, 0, delaytime)
            yield delaytime
            
        if 2 in self.players:
            #bot 3 cam
            plus.animateCamera((0,20,-10), (0.533,0), 0.6, (0,20,-10), (0.533,0), 0.45, 0, delaytime)
            yield delaytime
            
        if 3 in self.players:
            #bot 4 cam
            plus.animateCamera((0,20,10), (0.533,3.14), 0.6, (0,20,10), (0.533,3.14), 0.45, 0, delaytime)
            yield delaytime
            
        #fade out music
        plus.fadeOutLoop(self.intro_music, 2000)
        yield 2
        
        # done
        yield 0
        
    def Tick(self):
        for each in self.players:
            if plus.getLocation(each)[1] < 4.6:
                plus.eliminatePlayer(each)        
        return Arenas.SuperArena.Tick(self)

    def ZoneEvent(self, direction, id, robot, chassis):            
        return True

Arenas.register(RingArena)
